# **aiplans**: A TikZ-Based Library for Drawing POCL Plans

<aiplans> is a specialized LaTeX package designed to assist scientists, students, and professionals in creating high-quality graphical representations, particularly Partial Order Causal Link (POCL) plans. Built on the robust TikZ framework, this library simplifies the process of generating complex, precise diagrams that are essential for academic and scientific communication. Our package is especially useful in fields such as artificial intelligence and planning, where visualizing causal relationships and dependencies is fundamental.

## Content

- [Project Structure](#project-structure)
- [License](#license)
- [Future Improvements Plan](#future-improvements-plan)
- [Contact Information](#contact-information)
- [Team Members](#team-members)

## Project Structure

Aiplans/

├── **README.md**

├── **README.pdf**

├── **Generating TikZ Diagrams Using LaTeX.md**

├── **Generating TikZ Diagrams Using LaTeX.pdf**

├── **tikzlibrary<aiplans>.code.tex**

└── **License.txt**


### Explanation

- **README**: This file provides an overview of the project, including installation instructions, system requirements, and other essential information.
- **Generating TikZ Diagrams Using LaTeX**: Detailed instructions on how to use the TikZ library included in this package. It covers the steps needed to generate diagrams using LaTeX.
- **tikzlibrary<aiplans>.code.tex**: The core of the project, this file contains the TikZ library specifically designed for generating AI plan diagrams. This package is crucial for the functionality provided by this project.
- **License.txt**: The license file outlines the terms under which the package can be used, modified, and distributed.


## License

This material is subject to the [LaTeX Project Public License 1.3c](https://ctan.org/license/lppl1.3).


## Contact Information
If you have any questions, feedback, or suggestions regarding this project, please feel free to reach out to us. We are always happy to assist and appreciate your input.

Email: geyikai912@gmail.com

GitHub Issues: https://github.com/YikaiGe/tikz-aiplans/issues

For reporting bugs or requesting features.

CTAN Repository: https://ctan.org/pkg/aiplans?lang=en

Visit our package page on CTAN for the latest updates and documentation.

We strive to respond to all inquiries as quickly as possible.

## Team Members

This project is developed by a team of students from the Australian National University (ANU). The team members include:

### Client
- **Pascal Bercher**

### Maintainers
- **Yikai Ge**
- **Chen Wang**
- **Cheng Zhou**
- **Lujia Li**
- **Yinyin Chen**
- **Xinni Song**