#!/bin/perl
use English;
use Getopt::Long;
use FileHandle;
use File::Basename;
use File::Find;
use Cwd;
$_ = getcwd();
$ROOT=$_;

print "<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML//EN\">\n";
print "<HTML>\n";
print "<HEAD>\n";
print "<TITLE>Documentation Tree for TeX System</TITLE>\n";
print "</HEAD>\n";
print "<BODY>\n";
print "<h1>Documentation Tree for TeX System</h1>\n";
print "<HR>\n";
print "<p>This is a mechanically-generated catalogue of links to all  PostScript, HTML,\n";
print "and  DVI files in the <tt>texmf/doc</tt> tree. For a more sensible\n";
print "catalogue of HTML material only, consult the \n";
print "<a href=\"html/index.html\">HTML tree</a></p>\n";
print "<HR>\n";

find(\&dfiles,".");
$lastN=0;
foreach $D (sort keys %dirs) {
    chdir "$ROOT/$D";
    &buildfilelist;
    @f="";
    $nf=0;
   for (grep(/\.html|\.dvi|\.pdf|\.ps/,@filenames)) 
      { 
	  push @f, "<li><A href=\"$D/$_\">$_</A>";
	  $nf++;
    }
  if ($D ne "" && $D ne "html") {
        $_=$D;
	@depth=split("/") ;
        $N=$#depth+ 1;
	if ($N > $lastN) { 
	    $diff=$N-$lastN;
	    if ($diff eq 1) {  print "<OL>\n"; }
	    elsif ($diff eq 2) {  print "<OL><OL>\n"; }
	    elsif ($diff eq 3) {  print "<OL><OL>\n"; }
	    elsif ($diff eq 4) {  print "<OL><OL><OL><OL>\n"; }
	}
	elsif ($N < $lastN) { 
	    $diff=$lastN-$N;
	    if ($diff eq 1) {  print "</OL>\n"; }
	    elsif ($diff eq 2) {  print "</OL></OL>\n"; }
	    elsif ($diff eq 3) {  print "</OL></OL>\n"; }
	    elsif ($diff eq 4) {  print "</OL></OL></OL></OL>\n"; }
	}
        $lastN=$N;
       	print "<LI>$D\n";
        print "<ul>";
	for (@f) { print "$_\n";}
        print "</ul>\n";
    }
}

print "</OL>\n";
print "<HR>\n";
print "<ADDRESS></ADDRESS>\n";
print "</BODY>\n";
print "</HTML>\n";

sub dfiles {
if (-f) {      
    $x=$File::Find::dir;
    $x =~   s/^\.//;
    $x =~   s/^\///;
    $dirs{$x}="x"; 
}
elsif (-d) {        
    $x=$File::Find::dir;
    $x =~   s/^\.//;
    $x =~   s/^\///;
    $dirs{$x}="x"; 
}
}

sub buildfilelist {
    opendir(DIR,'.') || die ("ERROR: cannot open directory");
    @filenames =grep(!/^\.\.?$/,readdir(DIR));
    closedir(DIR);
}
