/* C4P - Pascal-to-C Translator
   Time-stamp: "97/01/03 17:44:22 mik"

   Copyright (C) 1991, 92, 93, 94, 95, 96, 97
	Christian Schenk  <cschenk@berlin.snafu.de>

   This file is part of MiKTeX.

   MiKTeX is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.
   
   MiKTeX is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with MiKTeX; if not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <getopt.h>
#include <limits.h>

#include "common.h"
#include "c4p.rc"

static char *myname;
char *pascal_file_name;
char *c_file_name;
char *include_filename;
int one_c_file;

unsigned max_lines_per_c_file;

int yyparse (void);
extern long yylineno;
extern char *yytext;

int
yywrap (void)

{
  return (1);
}

void
yyerror (const char *s)

{
  fprintf (stderr, "%s:%ld: parse error before `%s'\n",
	   pascal_file_name, yylineno, yytext);
  exit (1);
}

void
c4p_error (const char *fmt,
	   ...)

{
  va_list ap;

  fprintf (stderr, "%s:%ld: ", pascal_file_name, yylineno);
  va_start (ap, fmt);
  vfprintf (stderr, fmt, ap);
  va_end (ap);
  fputc ('\n', stderr);
  exit (2);
}

void
c4p_warning (const char *fmt,
	     ...)

{
  va_list ap;

  fprintf (stderr, "\n%s:%ld: warning: ", pascal_file_name, yylineno);
  va_start (ap, fmt);
  vfprintf (stderr, fmt, ap);
  va_end (ap);
  fputc ('\n', stderr);
}

static void
banner (void)

{
  printf ("This is C4P version %s\n", VER_FILEVERSION_STR);
}

static void
usage (void)

{
  puts ("Usage: c4p [options] filename");
  puts ("Options:");
  puts ("  -1 FILENAME, --one FILENAME");
  puts ("  -h, --help");
  puts ("  -i, include-filename FILENAME");
  puts ("  -l NUM, --lines NUM");
  puts ("  -p FILENAME, --output-prefix FILENAME");
  puts ("  -r NAME, --rename NAME");
  puts ("  -f VAR, --fast-var VAR");
  puts ("  -V, --version");
}

static struct option longopts[] =
{
  "help", 0, 0, 'h',
  "include-filename", 1, 0, 'i',
  "lines", 1, 0, 'l',
  "rename", 1, 0, 'r',
  "version", 0, 0, 'V',
  "fast-var", 1, 0, 'f',
  "one", 2, 0, '1',
  "output-prefix", 1, 0, 'p',
  0, 0, 0, 0,
};

static void
option_handler (int argc,
		char **argv)

{
  int opt;
  char new_name[ 50 ];

  optind = 0;
  myname = argv[0];
  one_c_file = 0;
  c_file_name = 0;
  macroizing = 0;
  include_filename = "c4plib.h";
  max_lines_per_c_file = 1000;
  while ((opt = getopt_long (argc, argv, "1:hi:l:r:Vf:", longopts, 0)) != EOF)
    {
      switch (opt)
	{
	case 'h':
	  usage ();
	  exit (0);
	  break;
	case 'i':
	  include_filename = optarg;
	  break;
	case 'l':
	  max_lines_per_c_file = (unsigned) atoi (optarg);
	  break;
	case 'r':
	  sprintf (new_name, "_c4p_%s", optarg);
	  new_mapping (optarg, new_name);
	  break;
	case 'f':
	  new_fast_var (optarg);
	  break;
	case 'p':
	  c_file_name = optarg;
	  break;
	case 'V':
	  banner ();
	  exit (0);
	  break;
	case '1':
	  one_c_file = 1;
	  if (optarg)
	    c_file_name = optarg;
	  break;
	default:
	  usage ();
	}
    }

  if (optind == argc - 1)
    pascal_file_name = argv[optind];
}

int
main (int argc,
      char **argv)

{
  symtab_init ();
  option_handler (argc, argv);

  if (pascal_file_name == 0)
    {
      fprintf (stderr, "%s: no input file specified\n", myname);
      exit (4);
    }

  if (freopen (pascal_file_name, "r", stdin) == 0)
    {
      fprintf (stderr, "%s: can't open %s\n", myname, pascal_file_name);
      exit (5);
    }

  yyparse ();

  return (0);
}
