/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.sp.pdftools;

import de.tu_darmstadt.sp.paul.PDFArray;
import de.tu_darmstadt.sp.paul.PDFDictionary;
import de.tu_darmstadt.sp.paul.PDFFile;
import de.tu_darmstadt.sp.paul.PDFName;
import de.tu_darmstadt.sp.paul.PDFObject;
import de.tu_darmstadt.sp.paul.PDFStream;
import de.tu_darmstadt.sp.paul.PDFStreamException;
import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class RecodePDF {
    public static final String PROGRAM = "PDFRecode";
    public static final String VERSION = "0.5";
    public static final int STEPPING = 10;
    private static final String shortOpts = "d:a:r:DqvhV";
    private static final LongOpt[] longOpts = new LongOpt[]{new LongOpt("delete", 1, null, 100), new LongOpt("add", 1, null, 97), new LongOpt("replace", 1, null, 114), new LongOpt("deleteall", 0, null, 68), new LongOpt("quiet", 0, null, 113), new LongOpt("verbose", 0, null, 113), new LongOpt("help", 0, null, 104), new LongOpt("version", 0, null, 86)};
    private static int verbosityLevel = 1;

    private static void addFilter(PDFStream stream, PDFName filter) {
        List filters = stream.getFilters();
        List parms = stream.getParms();
        filters.add(filter);
        parms.add(PDFObject.NULL);
        stream.changeFilters(filters, parms);
    }

    public static void main(String[] args) throws IOException {
        String inFile = null;
        String outFile = null;
        int command = 32;
        String subarg = null;
        String part1 = null;
        String part2 = null;
        try {
            int opt;
            Getopt options = new Getopt("pdfrecode", args, shortOpts, longOpts);
            block18: while ((opt = options.getopt()) != -1) {
                switch (opt) {
                    case 97: 
                    case 100: 
                    case 114: {
                        if (command != 32) continue block18;
                        command = opt;
                        subarg = options.getOptarg();
                        break;
                    }
                    case 68: {
                        command = opt;
                        break;
                    }
                    case 113: {
                        verbosityLevel = 0;
                        break;
                    }
                    case 118: {
                        verbosityLevel = 2;
                        break;
                    }
                    case 104: {
                        RecodePDF.showUsage(null);
                        break;
                    }
                    case 86: {
                        RecodePDF.showVersion();
                        break;
                    }
                    default: {
                        RecodePDF.showUsage("Illegal option '" + (char)options.getOptopt() + "' detected.");
                    }
                }
            }
            if (options.getOptind() + 2 != args.length) {
                RecodePDF.showUsage("You must specify PDF files to process.");
            }
            inFile = args[options.getOptind()];
            outFile = args[options.getOptind() + 1];
        }
        catch (Exception e) {
            RecodePDF.showUsage("Error: " + e.getMessage());
        }
        if (command == 32) {
            RecodePDF.showUsage("You must specify what should be done.");
        }
        if (command == 114) {
            if (subarg.indexOf(44) == -1) {
                RecodePDF.showUsage("Not enough filters provided.");
            }
            part1 = subarg.substring(0, subarg.indexOf(44) - 1);
            part2 = subarg.substring(subarg.indexOf(44) + 1);
        }
        PDFFile input = new PDFFile(inFile);
        RecodePDF.progress(1, "Reading input file...");
        input.read();
        HashSet objectList = new HashSet();
        RecodePDF.progress(1, "\nGathering list of objects...");
        RecodePDF.traverseGraph(input.getTrailer(), objectList);
        RecodePDF.progress(1, "\nConverting streams...");
        int count = 0;
        int failed = 0;
        Iterator j = objectList.iterator();
        block19: while (j.hasNext()) {
            PDFObject current;
            block20: while ((current = (PDFObject)j.next()) instanceof PDFStream) {
                try {
                    PDFStream stream = (PDFStream)current;
                    if (++count % 10 == 0) {
                        RecodePDF.progress(1, ".");
                    }
                    switch (command) {
                        case 100: {
                            RecodePDF.removeFilter(stream, PDFName.forString(subarg));
                            continue block19;
                        }
                        case 97: {
                            RecodePDF.addFilter(stream, PDFName.forString(subarg));
                            continue block19;
                        }
                        case 114: {
                            RecodePDF.replaceFilter(stream, PDFName.forString(part1), PDFName.forString(part2));
                            continue block19;
                        }
                        case 68: {
                            RecodePDF.removeAllFilters(stream);
                            continue block19;
                        }
                        default: {
                            if (j.hasNext()) continue block20;
                        }
                    }
                }
                catch (PDFStreamException e) {
                    --count;
                    ++failed;
                    RecodePDF.progress(1, "F");
                    RecodePDF.progress(2, "\n" + e.getMessage() + "\n");
                }
                continue block19;
            }
        }
        RecodePDF.progress(1, "\n" + count + " streams converted.");
        RecodePDF.progress(1, "\n" + failed + " streams failed conversion.\n");
        RecodePDF.progress(1, "Writing output file...");
        input.write(outFile);
        RecodePDF.progress(1, "\nDone!\n");
    }

    private static void progress(int level, String msg) {
        if (verbosityLevel >= level) {
            System.err.print(msg);
        }
    }

    private static void removeAllFilters(PDFStream stream) {
        stream.changeFilters(new ArrayList());
    }

    private static void removeFilter(PDFStream stream, PDFName filter) {
        List filters = stream.getFilters();
        List parms = stream.getParms();
        int pos = filters.indexOf(filter);
        if (pos != -1) {
            filters.remove(pos);
            parms.remove(pos);
        }
        stream.changeFilters(filters, parms);
    }

    private static void replaceFilter(PDFStream stream, PDFName oldFilter, PDFName newFilter) {
        List filters = stream.getFilters();
        List parms = stream.getParms();
        int pos = filters.indexOf(oldFilter);
        if (pos != -1) {
            filters.set(pos, newFilter);
            parms.set(pos, PDFObject.NULL);
        }
        stream.changeFilters(filters, parms);
    }

    static void showUsage(String message) {
        if (message != null) {
            System.err.println(message);
        }
        System.err.println("Usage: pdfrecode [options] infile outfile\nOptions:\n-d f, --delete f      Delete filter f from all streams\n-a f, --add          Add filter f to all streams\n-r f,g, --replace f,g Replace all occurences of filter f in all\n                      streams by filter g\n-D --deleteall        Delete all filters from all streams\n-q, --quiet           Do not print progress messages.\n-v, --verbose         Be verbose.\n-h, --help            Print this message and exit.\n-V, --version         Show version number.\n");
        System.exit(1);
    }

    private static void showVersion() {
        System.err.println("PDFRecode version 0.5\nCopyright (C) 1999, 2000 FG Systemprogrammierung, TU Darmstadt\nPDFRecode is free software; see the source for copying conditions.\nThere is NO warranty; not even for MERCHANTABILITY or FITNESS\nFOR A PARTICULAR PURPOSE.\n");
        System.exit(0);
    }

    private static void traverseGraph(PDFObject node, Set list) {
        if (!list.contains(node)) {
            Iterator i;
            list.add(node);
            if (node instanceof PDFArray) {
                i = ((PDFArray)node).listIterator();
                while (i.hasNext()) {
                    RecodePDF.traverseGraph((PDFObject)i.next(), list);
                }
            }
            if (node instanceof PDFDictionary) {
                i = ((PDFDictionary)node).iterator();
                while (i.hasNext()) {
                    RecodePDF.traverseGraph(((PDFDictionary)node).get((PDFName)i.next()), list);
                }
            }
            if (node instanceof PDFStream) {
                RecodePDF.traverseGraph(((PDFStream)node).getDictionary(), list);
            }
        }
    }
}

