# You should avoid calling any of these procs:
# They are slower, and may be removed at some point in the future.

# just wrappers around other procs

proc pushMark {} {pushPosition}
proc popMark {} {popPosition}
proc pushPosition {args} {uplevel placeBookmark $args}
proc popPosition {args} {uplevel returnToBookmark $args}
proc absolutePath {filename} {file::absolutePath $filename}
proc openFileQuietly {filename} {
    edit -c -w $filename
}
proc searchInFile {filename searchString {indices 0}} {
    file::searchFor $filename $searchString $indices
}

proc readFile {fileName} {file::readAll $fileName}
proc writeFile {filename {text {}} {overwrite 0}} {
    file::writeAll $filename $text $overwrite
}
proc gotoFileLine {fname line {mesg {}}} {
    file::gotoLine $fname $line $mesg
}

proc buildSubMenu {args} {
    eval menu::buildHierarchy $args
}

proc listSubfolders {folder {depth 3}} {
    file::hierarchy $folder $depth
}

proc getIncludeFiles {} { optClickTB_List }
proc editIncludeFile {item} { optClickTB_Pick $item}
proc tryElseDump {name script} {
    try::level \#0 $script -reporting log -while $name
}
proc text::genericIndent {} { ::indentLine }

proc revertTheseFiles {flist} {eval file::revertThese $flist}


########################################
#			               #
#    A few random lisp'ish functions.  #
#				       #
########################################

proc car {l} {lindex $l 0}
proc cadr {l} {lindex $l 1}
proc caddr {l} {lindex $l 2}
proc cadddr {l} {lindex $l 3}
proc caddddr {l} {lindex $l 4}
proc cdr {l} {lrange $l 1 end}
proc cddr {l} {lrange $l 2 end}

proc mapcar args {return [eval map $args]}

proc map {func l} {
    set out {}
    foreach el $l {
	lappend out [eval $func [list $el]]
    }
    return $out
}

proc cons {e l} {concat [list $e] $l}

