/*
 * Decompiled with CFR 0.152.
 */
package nts.io;

import java.io.IOException;
import java.io.Writer;
import nts.io.BaseLineOutput;
import nts.io.CharCode;

public final class WriterLineOutput
extends BaseLineOutput
implements CharCode.CharWriter {
    private Writer out;
    private CharCode.Maker maker;
    private boolean worryRoom;
    private int maxLineChars;
    private int numLineChars = 0;
    private String lineSeparator;
    private boolean trouble = false;

    public final void add(CharCode code) {
        if (code.isNewLine()) {
            this.endLine();
        } else {
            code.writeExpChars(this);
        }
    }

    public final void add(char chr) {
        if (this.maker.isNewLine(chr)) {
            this.endLine();
        } else {
            this.maker.writeExpChars(chr, this);
        }
    }

    public final void writeChar(char chr) {
        try {
            this.out.write(chr);
            ++this.charCount;
            ++this.numLineChars;
            if (this.maxLineChars > 0 && this.numLineChars >= this.maxLineChars) {
                this.endLine();
            }
        }
        catch (IOException x) {
            this.trouble = true;
        }
    }

    public final void addRaw(String str) {
        try {
            this.out.write(str);
        }
        catch (IOException x) {
            this.trouble = true;
        }
    }

    public final void endLine() {
        try {
            this.out.write(this.lineSeparator);
            this.out.flush();
        }
        catch (IOException x) {
            this.trouble = true;
        }
        this.numLineChars = 0;
    }

    public final void flush() {
        try {
            this.out.flush();
        }
        catch (IOException x) {
            this.trouble = true;
        }
    }

    public final void close() {
        try {
            this.out.close();
        }
        catch (IOException x) {
            this.trouble = true;
        }
    }

    public final void setStartLine() {
        this.numLineChars = 0;
    }

    public final boolean isStartLine() {
        return this.numLineChars == 0;
    }

    public final boolean stillFits(int count) {
        return !(this.worryRoom && this.numLineChars + count > this.maxLineChars);
    }

    public WriterLineOutput(Writer out, CharCode.Maker maker, boolean worryRoom, int maxLineChars) {
        this.out = out;
        this.maker = maker;
        this.worryRoom = worryRoom && maxLineChars > 0;
        this.maxLineChars = maxLineChars;
        this.lineSeparator = System.getProperty("line.separator");
    }

    public WriterLineOutput(Writer out, CharCode.Maker maker) {
        this(out, maker, false, 0);
    }
}

