/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.mail;

import java.net.InetAddress;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.ujmp.core.util.ConsoleUtil;

public class MailUtil {
    public static void sendSystemOut(String recipient, String subject, String smtpServer, String userName, String password) throws Exception {
        MailUtil.sendMessage(recipient, subject, ConsoleUtil.getSystemOut(), smtpServer, userName, password);
    }

    public static void sendSystemErr(String recipient, String subject, String smtpServer, String userName, String password) throws Exception {
        MailUtil.sendMessage(recipient, subject, ConsoleUtil.getSystemErr(), smtpServer, userName, password);
    }

    public static void sendMessage(String recipient, String subject, String text, String smtpServer, String userName, String password) throws Exception {
        Properties properties = new Properties();
        properties.put("mail.transport.protocol", "smtp");
        properties.put("mail.user", userName);
        properties.put("mail.smtp.host", smtpServer);
        if (password != null) {
            properties.put("Password", password);
        }
        properties.put("mail.from", "ujmp@" + InetAddress.getLocalHost().getHostName());
        Session mailSession = Session.getInstance((Properties)properties);
        MimeMessage message = new MimeMessage(mailSession);
        message.setSubject(subject);
        message.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(recipient));
        MimeMultipart mimeMultipart = new MimeMultipart();
        MimeBodyPart textPart = new MimeBodyPart();
        textPart.setText(text);
        textPart.setDisposition("inline");
        mimeMultipart.addBodyPart((BodyPart)textPart);
        message.setContent((Multipart)mimeMultipart);
        message.saveChanges();
        Transport.send((Message)message);
    }
}

