/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.viewers;

import au.com.pegasustech.demos.layout.SCLayout;
import com.jidesoft.grid.SortableTable;
import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.reports.api.Report;
import edu.mit.broad.genome.swing.GuiHelper;
import edu.mit.broad.genome.viewers.AbstractViewer;
import edu.mit.broad.xbench.core.JObjectsList;
import edu.mit.broad.xbench.core.api.Application;
import edu.mit.broad.xbench.tui.SingleToolLauncher;
import edu.mit.broad.xbench.tui.TaskManager;
import edu.mit.broad.xbench.tui.ToolRunnerControl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingWorker;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import xtools.api.Tool;

public class ReportViewer
extends AbstractViewer {
    public static final String NAME = "ReportViewer";
    public static final Icon ICON = JarResources.getIcon("past_analysis16.gif");
    private final Report fReport;
    private ReportViewer fInstance = this;
    private final Properties fParams;
    private static final String[] COL_HEADERS = new String[]{"Parameter name", "Parameter value"};

    public ReportViewer(Report rpt) {
        super(NAME, ICON, rpt);
        this.fReport = rpt;
        this.fParams = this.fReport.getParametersUsed();
        this.jbInit();
    }

    private void jbInit() {
        SCLayout scl = new SCLayout(3);
        scl.setRowScale(0, 0.1);
        scl.setRowScale(1, 0.45);
        scl.setRowScale(2, 0.45);
        this.setLayout((LayoutManager)scl);
        Date d = new Date(this.fReport.getTimestamp());
        StringBuffer buf = new StringBuffer("<html><body><b><f bold>Report: </b><font color=blue>").append(this.fReport.getName()).append("</font><br>");
        buf.append("<b>Date  : </b><font color=blue>").append(d.toString());
        buf.append("</font></body></html>");
        JLabel label = new JLabel(buf.toString());
        this.add(label);
        this.add(this.createParamPanel(this.fReport.getName()));
        JObjectsList jol = new JObjectsList(this.fReport.getFilesProduced());
        jol.setBorder(GuiHelper.createTitledBorderForComponent("Files produced as part of this analysis (double-click to view)"));
        this.add(new JScrollPane(jol));
        this.revalidate();
    }

    private JPanel createParamPanel(final String rptName) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        SortableTable table = new SortableTable((TableModel)new Model());
        table.setColumnSelectionAllowed(true);
        table.setRowSelectionAllowed(true);
        table.getTableHeader().setReorderingAllowed(false);
        ReportViewer.setColumnSize(75, 0, (JTable)table, false);
        panel.add((Component)new JScrollPane((Component)table), "Center");
        JPanel cp = new JPanel();
        final JCheckBox cxLoad = new JCheckBox("Load data", true);
        cxLoad.setToolTipText("Follow files specified in params and load their data");
        cp.add(cxLoad);
        JButton bRelaunch = new JButton("Show in ToolRunner", SingleToolLauncher.ICON);
        bRelaunch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingWorker<Object, Void> worker = new SwingWorker<Object, Void>(){

                    @Override
                    protected Object doInBackground() throws Exception {
                        try {
                            Tool tool = TaskManager.createTool(ReportViewer.this.fReport.getProducer().getName());
                            Runnable runnable = ToolRunnerControl.createLoadToolTask(tool, rptName, cxLoad.isSelected(), ReportViewer.this.fParams, ReportViewer.this.fInstance, true);
                            Thread t = new Thread(runnable);
                            t.setPriority(1);
                            t.start();
                        }
                        catch (Throwable t) {
                            Application.getWindowManager().showError(t);
                        }
                        return null;
                    }
                };
                worker.execute();
            }
        });
        cp.add(bRelaunch);
        panel.add((Component)cp, "South");
        return panel;
    }

    @Override
    public JMenuBar getJMenuBar() {
        return EMPTY_MENU_BAR;
    }

    private class Model
    extends AbstractTableModel {
        private final String[] keys;

        private Model() {
            this.keys = new String[ReportViewer.this.fParams.size()];
            int cnt = 0;
            Enumeration<Object> en = ReportViewer.this.fParams.keys();
            while (en.hasMoreElements()) {
                this.keys[cnt++] = en.nextElement().toString();
            }
        }

        @Override
        public int getRowCount() {
            return this.keys.length;
        }

        @Override
        public int getColumnCount() {
            return COL_HEADERS.length;
        }

        @Override
        public String getColumnName(int col) {
            return COL_HEADERS[col];
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return true;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return this.keys[row];
            }
            return ReportViewer.this.fParams.getProperty(this.keys[row]);
        }
    }
}

