/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.data.expr;

import java.util.HashMap;
import java.util.Map;
import org.genepattern.data.expr.IExpressionData;
import org.genepattern.data.expr.MetaData;
import org.genepattern.data.matrix.DoubleMatrix2D;
import org.genepattern.data.matrix.ObjectMatrix2D;

public class ExpressionData
implements IExpressionData {
    protected DoubleMatrix2D dataset;
    protected Map matrices;
    protected MetaData rowMetaData;
    protected MetaData columnMetaData;

    public ExpressionData(DoubleMatrix2D dataset, String[] _rowDescriptions, String[] _columnDescriptions) {
        this.dataset = dataset;
        this.rowMetaData = new MetaData(dataset.getRowCount());
        if (_rowDescriptions != null) {
            if (_rowDescriptions.length != dataset.getRowCount()) {
                throw new IllegalArgumentException("Length of row descriptions not equal to number of rows in matrix.");
            }
            this.rowMetaData.setMetaData("description", _rowDescriptions);
        }
        this.columnMetaData = new MetaData(dataset.getColumnCount());
        if (_columnDescriptions != null) {
            if (_columnDescriptions.length != dataset.getColumnCount()) {
                throw new IllegalArgumentException("Length of column descriptions not equal to number of columns in matrix.");
            }
            this.columnMetaData.setMetaData("description", _columnDescriptions);
        }
        this.matrices = new HashMap();
    }

    public ExpressionData(DoubleMatrix2D dataset, MetaData rowMetaData, MetaData columnMetaData, Map matrices) {
        this.dataset = dataset;
        this.rowMetaData = rowMetaData;
        this.columnMetaData = columnMetaData;
        this.matrices = matrices;
        if (this.matrices == null) {
            this.matrices = new HashMap();
        }
    }

    public ExpressionData slice(int[] rowIndices, int[] columnIndices) {
        int i;
        if (rowIndices == null) {
            rowIndices = new int[this.dataset.getRowCount()];
            i = this.dataset.getRowCount();
            while (--i >= 0) {
                rowIndices[i] = i;
            }
        }
        if (columnIndices == null) {
            columnIndices = new int[this.dataset.getColumnCount()];
            i = this.dataset.getColumnCount();
            while (--i >= 0) {
                columnIndices[i] = i;
            }
        }
        DoubleMatrix2D newDoubleMatrix2D = this.dataset.slice(rowIndices, columnIndices);
        MetaData newRowMetaData = this.rowMetaData.slice(rowIndices);
        MetaData newColumnMetaData = this.columnMetaData.slice(columnIndices);
        HashMap<String, ObjectMatrix2D> newMatrices = new HashMap<String, ObjectMatrix2D>();
        for (String key : this.matrices.keySet()) {
            ObjectMatrix2D m = (ObjectMatrix2D)this.matrices.get(key);
            newMatrices.put(key, m.slice(rowIndices, columnIndices));
        }
        return new ExpressionData(newDoubleMatrix2D, newRowMetaData, newColumnMetaData, newMatrices);
    }

    @Override
    public int getRowCount() {
        return this.dataset.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this.dataset.getColumnCount();
    }

    @Override
    public double getValue(int row, int column) {
        return this.dataset.get(row, column);
    }

    @Override
    public String getValueAsString(int row, int column) {
        return String.valueOf(this.dataset.get(row, column));
    }

    @Override
    public String getColumnName(int column) {
        return this.dataset.getColumnName(column);
    }

    @Override
    public String getRowName(int row) {
        return this.dataset.getRowName(row);
    }

    @Override
    public int getRowIndex(String rowName) {
        return this.dataset.getRowIndex(rowName);
    }

    @Override
    public int getColumnIndex(String columnName) {
        return this.dataset.getColumnIndex(columnName);
    }

    @Override
    public Object getData(int row, int column, String name) {
        ObjectMatrix2D matrix = (ObjectMatrix2D)this.matrices.get(name);
        return matrix != null ? matrix.get(row, column) : null;
    }

    @Override
    public String getRowMetadata(int row, String name) {
        return this.rowMetaData.getMetaData(row, name);
    }

    @Override
    public String getColumnMetadata(int column, String name) {
        return this.columnMetaData.getMetaData(column, name);
    }

    @Override
    public String getDataName(int index) {
        return this.matrices.keySet().toArray(new String[0])[index];
    }

    @Override
    public int getDataCount() {
        return this.matrices.size();
    }
}

