/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg;

import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.Annot;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DefaultDataset;
import java.util.ArrayList;
import java.util.List;

public class DatasetBuilder {
    public String fName;
    public List<Vector> fRows;
    public List<String> fRowNames;
    public List<String> fRowDescs;
    public List<String> fColNames;
    public boolean fDoneBuilding;

    public DatasetBuilder(String name, List<String> colNames) {
        if (name == null) {
            throw new IllegalArgumentException("Name param cant be null");
        }
        if (colNames == null) {
            throw new IllegalArgumentException("colanmes param cant be null");
        }
        this.fName = name;
        this.fDoneBuilding = false;
        this.fColNames = new ArrayList<String>(colNames);
        this.fRowNames = new ArrayList<String>();
        this.fRows = new ArrayList<Vector>();
        this.fRowDescs = new ArrayList<String>();
    }

    public void addRow(int rowInDs, Dataset fromDs) {
        this.checkBuild();
        this.fRows.add(fromDs.getRow(rowInDs));
        this.fRowNames.add(fromDs.getRowName(rowInDs));
    }

    public Dataset generate(Annot ann) {
        Matrix matrix = new Matrix(this.fRows.size(), this.fColNames.size());
        for (int i = 0; i < this.fRows.size(); ++i) {
            matrix.setRow(i, this.fRows.get(i));
        }
        DefaultDataset ds = new DefaultDataset(this.fName, matrix, this.fRowNames, this.fColNames, ann);
        this.fDoneBuilding = true;
        return ds;
    }

    private void checkBuild() {
        if (this.fDoneBuilding) {
            throw new RuntimeException("Already done building -- DatasetBuilder cannot be reused");
        }
    }
}

