/*
 * Decompiled with CFR 0.152.
 */
package xapps.gsea;

import edu.mit.broad.genome.objects.MSigDBSpecies;

public class GseaWebResources {
    public static final String GSEA_FTP_SERVER = "ftp.broadinstitute.org";
    private static final String GSEA_FTP_SERVER_USERNAME = "anonymous";
    private static final String GSEA_FTP_SERVER_PASSWORD = "gsea@broadinstitute.org";
    public static final String GSEA_FTP_SERVER_BASE_DIR = "/pub/gsea/msigdb";
    private static final String GSEA_FTP_SERVER_CHIPFILES_SUB_DIR = "annotations";
    private static final String GSEA_FTP_SERVER_HUMAN_CHIPFILES_DIR = "/pub/gsea/msigdb/human/annotations";
    private static final String GSEA_FTP_SERVER_MOUSE_CHIPFILES_DIR = "/pub/gsea/msigdb/mouse/annotations";
    private static final String GSEA_FTP_SERVER_GENESETS_SUB_DIR = "gene_sets";
    private static final String GSEA_FTP_SERVER_HUMAN_GENESETS_DIR = "/pub/gsea/msigdb/human/gene_sets";
    private static final String GSEA_FTP_SERVER_MOUSE_GENESETS_DIR = "/pub/gsea/msigdb/mouse/gene_sets";

    public static String getGseaFTPServer() {
        return GSEA_FTP_SERVER;
    }

    public static String getGseaFTPServerUserName() {
        return GSEA_FTP_SERVER_USERNAME;
    }

    public static String getGseaFTPServerPassword() {
        return GSEA_FTP_SERVER_PASSWORD;
    }

    public static String getGseaFTPServerChipDir(MSigDBSpecies targetSpecies) {
        switch (targetSpecies) {
            case Human: {
                return GSEA_FTP_SERVER_HUMAN_CHIPFILES_DIR;
            }
            case Mouse: {
                return GSEA_FTP_SERVER_MOUSE_CHIPFILES_DIR;
            }
        }
        throw new IllegalArgumentException("No FTP directory for " + targetSpecies.name());
    }

    public static String getGseaFTPServerGeneSetsDir(MSigDBSpecies targetSpecies) {
        switch (targetSpecies) {
            case Human: {
                return GSEA_FTP_SERVER_HUMAN_GENESETS_DIR;
            }
            case Mouse: {
                return GSEA_FTP_SERVER_MOUSE_GENESETS_DIR;
            }
        }
        throw new IllegalArgumentException("No FTP directory for " + targetSpecies.name());
    }

    public static String getGseaBaseURL() {
        return "https://www.gsea-msigdb.org/gsea";
    }

    public static String getGseaURLDisplayName() {
        return "www.gsea-msigdb.org/gsea";
    }

    public static String getGseaHelpURL() {
        return GseaWebResources.getGseaBaseURL() + "/wiki";
    }

    public static String getGseaContactURL() {
        return GseaWebResources.getGseaBaseURL() + "/contact.jsp";
    }

    public static String getGseaDataFormatsHelpURL() {
        return GseaWebResources.getGseaBaseURL() + "/wiki/index.php/Data_formats";
    }

    public static String getGseaChipInfoHelpURL() {
        return GseaWebResources.getGseaBaseURL() + "/wiki/index.php/CHIP_File_Selection_Help";
    }

    public static String getHumanArrayAnnotationsURL() {
        return "https://data.broadinstitute.org/gsea-msigdb/msigdb/annotations/human/";
    }

    public static String getMouseArrayAnnotationsURL() {
        return "https://data.broadinstitute.org/gsea-msigdb/msigdb/annotations/mouse/";
    }

    public static String getGseaExamplesURL() {
        return GseaWebResources.getGseaBaseURL() + "/datasets.jsp";
    }
}

